#!/usr/bin/env python
# coding: utf-8

# # Python course 3: NumPy and SciPy
# 
# Markus Reinert, 2021-04-30

# ## Import the necesseray modules

# In[1]:


import numpy as np
from scipy import special


# If you need to use a function many times, you can use the following notation:

# In[2]:


# from numpy import sin


# For visualization purposes, we also import MatPlotLib, which we'll discuss in the next course.

# In[3]:


from matplotlib import pyplot as plt


# ## Mathematics

# Let's calculate $\sin(x)$ for some values of $x$.

# In[4]:


for x in [-np.pi / 2, 0, 1, np.pi / 2]:
    print("The sine of", x, "is", np.sin(x))
    # Uncomment the following line for a nicer way of printing
    # print(f"sin({x:+.2f}) = {np.sin(x)}")


# Let's calculate $\Gamma(4)$ which should be equal to $3!$ (factorial).

# In[5]:


special.gamma(4)


# ## Random numbers

# In[6]:


print("A random number between 0 and 9:", np.random.randint(10))


# To compute many random numbers at once, use the following notation:

# In[7]:


print("100 random numbers between 0 and 9:")
np.random.randint(10, size=(100))


# ## Arrays

# Let's create a list and convert it to an array.

# In[8]:


l = [3, 5, 2.1, 0, -3]
a = np.array(l)

print(l)
print(a)


# They look the same, but note that all elements in $\texttt{a}$ are floats (they have a dot at the end).

# Let's create a vector and an array full with zeros.

# In[9]:


np.zeros(10)


# In[10]:


np.zeros((3, 3))  # note the double-brackets


# Let's create a 3D-array with ones.

# In[11]:


np.ones((2, 3, 4))


# Let's create an array of ones that is compatible to our array $\texttt{a}$ above.

# In[12]:


b = np.ones_like(a)
print(b)


# To create an array of tens, there are several ways:

# In[13]:


np.full(3, fill_value=10)


# In[14]:


np.ones(3) * 10


# ## Numerical 1D-ranges

# The function $\texttt{np.arange}$ works similar to Python's $\texttt{range}$ ...

# In[15]:


y = np.arange(10)
print(y)


# ... but can also do non-integer steps ...

# In[16]:


np.arange(0, 10, 0.5)


# ... and can go backwards as well.

# In[17]:


np.arange(10, 0, -0.5)


# When we want to make sure that the start- and end-point are in the range, we use:

# In[18]:


x = np.linspace(-1, 1, 100)
print(x)


# ## From 1D to 2D

# In[19]:


X, Y = np.meshgrid(x, y)


# In[20]:


print("The x-coordinate has", x.ndim, "dimension and length:", x.size)
print("The y-coordinate has", y.ndim, "dimension and length:", y.size)
print("So the coordinate matrix X has", X.ndim, "dimensions")
print("with a shape of", X.shape, "and thus the size", X.size)
print(
    "The same for Y; dimensions:", Y.ndim,
    "and shape:", X.shape,
    "and size:", X.size,
)


# In[21]:


fig, axs = plt.subplots(ncols=2, figsize=(10, 2))

ax = axs[0]
ax.set_title("2D-matrix X")
ax.set_xlabel("x-coordinate")
ax.set_ylabel("y-coordinate")
im = ax.imshow(X)
fig.colorbar(im, ax=ax)

ax = axs[1]
ax.set_title("2D-matrix Y")
ax.set_xlabel("x-coordinate")
ax.set_ylabel("y-coordinate")
im = ax.imshow(Y)
fig.colorbar(im, ax=ax)


# Note that you can also use the following notation, which is more to type but also works for lists:

# In[22]:


np.size(X)


# In[23]:


np.size(l)


# In[24]:


np.size([1, 2, 3])


# For 1D-lists, this is equivalent to $\texttt{len}$, but this is not generally the case.

# ## Calculations with vectors and matrices

# Let's create a matrix ...

# In[25]:


A = np.random.random((3, 4))
print(A)


# ... and two vectors

# In[26]:


vector = np.array([0, 1, 2, 3])
print(vector)

vector2 = np.array([1, 0, -1])
print(vector2)


# Elementwise multiplication works like this:

# In[27]:


A * vector


# but if the dimensions don't match, we have to extend the vector to the correct shape like this:

# In[28]:


A * vector2[:, np.newaxis]


# The multiplication from linear algebra works like this:

# In[29]:


A @ vector


# Or, more explicitely:

# In[30]:


np.dot(A, vector)


# We can select parts of an array with indices:

# In[31]:


A[:, 1:3]


# or based on a condition:

# In[32]:


(A > 0.5) & (A < 0.9)


# Extract the values where the condition is True:

# In[33]:


A[(A > 0.5) & (A < 0.9)]


# Obtain their indices:

# In[34]:


np.where((A > 0.5) & (A < 0.9))


# We can also use arrays in mathematical functions:

# In[35]:


2 * A  # elementwise multiplication with 2


# In[36]:


vector + 1  # elementwise addition


# In[37]:


np.sqrt(A)  # calculate the square root of every value in A


# Last time, we have seen the following notation to do calculations for every element in a list.
# With NumPy, you can make this more efficiently, especially for large vectors.
# 
# **Do you know how?**
# 
# *(Hint: I need two lines of code for it.)*

# In[38]:


[1 / x if x != 0 else 0.0 for x in vector]


# ## Joining arrays into a single array

# In[39]:


np.concatenate((A, vector2[:, np.newaxis]), axis=1)


# In[ ]:




