#This is a comment

#loading packages
import numpy
#or
import numpy as np #a package for working with arrays in a fast way
import matplotlib.pyplot as plt #plotting environment
# also possible:
from math import *

#in python you can define variables without specifying the type:
x=1 #int
x=1.0 #float
x='1' 
x="1"
#string
x=[1,2,3,4] # a python list with the only element 1 as an integer
x=np.array(x) #converting a python list into a numpy array 
print(type(x)) #print = give an output to console, type(x): check what type the variable is
#in the examples above we always overwrote x

#note the differences in division:
a_int=2
a_float=2.0
b_int=9
b_float=9.0
print(b_int/a_int) #the result is not 4.5 since the numerator is an integer
print(b_float/a_int) #using a float as the numerator fixes the problem
print(b_int/a_float) #also a float as the denominator fixes the problem

#creating arrays:
#the easiest way to do this is using numpy
x_ar = np.linspace(1,10,100) #creates an array of length 100 between 1 and 10 
print(len(x_ar)) #you can check the length of an array using the len() function. This only works for 1-D arrays
print(x_ar)
y_ar = np.arange(1,10,0.1) #creates an array with values between 1 and 10 with a stepsize of 0.1
print(len(y_ar))
print(y_ar)
z_ar = np.zeros((100)) #creates an array of shape (100,) with zeros
print(len(z_ar))
print(z_ar)
z_ar = np.zeros((100,1)) #creates an array of shape (100,1) with zeros. Note that here the entries are an array themselves.
# Technically this is already a 2-D array
print(len(z_ar))
print(z_ar)
#similar you can write ones with np.ones((100,))
a_ar = np.full((100,), 100)
print(a_ar)
x_2D = np.full((100,50),100)
print(len(x_2D)) #this gives only the length of the first axis!
print(np.shape(x_2D)) # this gives back all dimensions 

#accessing entries of an array 
#the indexing in python starts with 0! To access the first values of an array one uses []:
print(x_ar[0]) #gives back the first value
print(x_2D[0]) #gives back the first array since it is a 2D array
print(x_2D[0,0]) #gives back the element stored at position [0,0]
x_2D[10,10] = 300.0 #you can also change vaues this way
print(x_2D[10,10])
#accessing slices:
print(y_ar[1:10]) #gives back the values from index 1 to 9! , so start:end = array with values from start to end-1
print(y_ar[::5]) # only every fifth values is accessed
print(y_ar[50:]) #if you dont give the end values the whole array is given back starting from the start value
print(y_ar[50:None]) #the same cna be achieved using None which can be stored in a variable, which is useful when doing something
# like y_ar[a:b] where a and b may change, i.e. in a running mean function

#defining a function
def addition(a,b):
    c=a+b
    return(c)
addition(1,2)
print(addition(10,4))
d=addition(3,5)
#the great davantage of numpy arrays is the ability to add two arrays of the same size. this means our defined function can be used
#for numpy arrays as well:
a=np.array([1.0,2.0,3.0])
b=np.array([3,4,5])
print(addition(a,b))
print(a**(-2))
#this is way faster than writing a while loop to do the addition entrywise

#while loop
#in python there are no brackets to denote the end of a loop or an if clause, python uses indent, typically a 'tab'

x_ar = np.zeros((100,))
i=0
while i < 100: #something is done as long as i is smaller than 100, we need to increase i, otherwise we created an infinite loop
    x_ar[i] = i*i
    print(i) #do something
    i+=1 # i=i+1
#the loop ends here!
print(x_ar)

#if clause: if the expression after if is True, then the code intended is done, otherwise not
x = 1
if x == 1: #== equal, <=,>=,<,>,!= (not equal)
    #do something
    print(x)
#if clause ends here
    
#doing simple plots:
#we need the matplotlib package for that
    
#define x_axis:
x_axis=np.arange(1,101,1)
y_axis=x_ar

plt.figure() #initiate the plot figure
plt.plot(x_axis,y_axis) #do the plot, you can also change the color of the plot here,i.e. color='green'
plt.xlabel('x-Achse') #name the x_axis
plt.ylabel('y-Achse') #name the y_axis
plt.show()#shows the figure
plt.savefig("/home/lorenz/ownCloud/Theoretical_Oceanography/test.png")#save the figure to a path you can define as a string
plt.close()#close the figure again
#do a 2-D plot
z = np.zeros((100,50)) #this will be the color, note that z has to have the dimension (y,x)!!!
x = np.arange(50)
y = np.arange(100)

#fill the z data
i=0
while i < np.shape(z)[0]:
    j=0
    while j < np.shape(z)[1]:
        z[i,j] = i+j*i
        j+=1
    i+=1

plt.figure() #initiate the plot figure
plt.pcolor(x,y,z) #do the plot, you can also change the color of the plot here,i.e. color='green'
plt.colorbar() #add a colorbar
plt.xlim([x[0],x[-1]]) #since pcolor creates these "ugly" white lines due to how it plot, we change the plotting area
#using plt.xlim
plt.xlabel('x-Achse') #name the x_axis
plt.ylabel('y-Achse') #name the y_axis
plt.show()#shows the figure
plt.savefig("/home/lorenz/ownCloud/Theoretical_Oceanography/test_pcolor.png")


#save and load data
#first lets save an ascii file:
data=np.array([x_axis,y_axis])
print(np.shape(data))
np.savetxt("/home/lorenz/ownCloud/Theoretical_Oceanography/test.txt",data.transpose(), delimiter='\t')#we transpose the data here 
#to get the two column style, without the transposing, the data is saved as two rows
#load data, method 1:
data = np.loadtxt("/home/lorenz/ownCloud/Theoretical_Oceanography/test.txt")
print(data)

plt.figure() #initiate the plot figure
plt.plot(data[:,0],data[:,1]) #do the plot, you can also change the color of the plot here,i.e. color='green'
plt.xlabel('x-Achse') #name the x_axis
plt.ylabel('y-Achse') #name the y_axis
plt.show()#shows the figure

#method 2:
x,y = np.loadtxt("/home/lorenz/ownCloud/Theoretical_Oceanography/test.txt",unpack=True) #here we can split 
#each column into an own variable

plt.figure() #initiate the plot figure
plt.plot(x,y) #do the plot, you can also change the color of the plot here,i.e. color='green'
plt.xlabel('x-Achse') #name the x_axis
plt.ylabel('y-Achse') #name the y_axis
plt.show()#shows the figure